#include "userprocess.h"
#include <stdio.h>
#include "message.h"
#include "sn_debug.h"

User_Process::User_Process(int diameter, int num_connections)
{
	diam = diameter;
	num_conns = num_connections;
}

// ----------------------------------------------------------------------------

void User_Process::Set_Start_State()
{
	u = process_id;
	max_uid = process_id;
	status = unknown;
	rounds = 0;
}

// ----------------------------------------------------------------------------

void User_Process::Generate_Messages()
{
	int loop;

	printf("Process %d: send=%d\n",process_id, max_uid);

	map<Message *,int> outgoing_messages;

	// Remember process ids are 1 based!
	for (loop = 0; loop < (num_conns + 1); loop++)
		if ((loop + 1) != process_id)
		{
			Message* outgoing_message = new Message;
			outgoing_message->uid = max_uid;

			pair<Message *,int> msg_to_pair(outgoing_message, loop+1);
			outgoing_messages.insert(msg_to_pair);
		}

	// --------------------------------
	// Convert Messages to SN_Messages
	map<SN_Message *,int> outgoing_sn_messages;

	map<Message *,int>::iterator a_message;
	for (a_message = outgoing_messages.begin();a_message != outgoing_messages.end();
		a_message++)
	{
		SN_Message* sn_message_ptr = reinterpret_cast<SN_Message *> (a_message->first);
		outgoing_sn_messages.insert(make_pair(sn_message_ptr,a_message->second));
	}
	// --------------------------------

	Send(&outgoing_sn_messages);

	for (a_message = outgoing_messages.begin();a_message != outgoing_messages.end();
		a_message++)
	{
		delete (a_message->first);
	}
}

// ----------------------------------------------------------------------------

void User_Process::Transition(map<SN_Message *,int> inbound_sn_msgs)
{
	// -----------------------------------------------------------
	// First convert all the SN_Messages to our Messages
	map<Message *,int> inbound_msgs;
	map<SN_Message *,int>::iterator an_sn_msg;
	
	for(an_sn_msg = inbound_sn_msgs.begin();
		an_sn_msg != inbound_sn_msgs.end(); an_sn_msg++)
	{
		Message *a_msg = reinterpret_cast<Message *>(an_sn_msg->first);
		inbound_msgs.insert(make_pair(a_msg,an_sn_msg->second));
	}
	// -----------------------------------------------------------

	rounds++;

	map<Message *,int>::iterator a_message;

	for (a_message = inbound_msgs.begin();a_message != inbound_msgs.end();
		 a_message++)
	{
		Message inbound_msg = *(a_message->first);
		if (inbound_msg.uid > max_uid)
			max_uid = inbound_msg.uid;
	}

	printf("Process %d: received %d messages\n", u, inbound_msgs.size());

	if (rounds == diam)
	{
		if (max_uid == u)
		{
			status = leader;
			printf("-->PROCESS %d DECLARED ITSELF THE LEADER...<--\n",u);
		}
		else
		{
			status = non_leader;
			printf("-->PROCESS %d DECLARED ITSELF A NON-LEADER...<--\n",u);
		}
	}
}
